/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.serialization.JsonMetadataList;
import org.apache.tika.server.MetadataList;

@Provider
@Produces(value={"application/json"})
public class MetadataListMessageBodyWriter
implements MessageBodyWriter<MetadataList> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!MediaType.APPLICATION_JSON_TYPE.equals(mediaType)) {
            return false;
        }
        return type.isAssignableFrom(MetadataList.class);
    }

    @Override
    public long getSize(MetadataList data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(MetadataList list, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream, StandardCharsets.UTF_8);
            JsonMetadataList.toJson(list.getMetadata(), writer);
            ((Writer)writer).flush();
        }
        catch (TikaException e) {
            throw new IOException(e);
        }
        entityStream.flush();
    }
}

