/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class HttpServletRequestSnapshot
extends HttpServletRequestWrapper {
    private String authType;
    private String characterEncoding;
    private int contentLength;
    private String contentType;
    private String contextPath;
    private Cookie[] cookies;
    private String localAddr;
    private Locale local;
    private Enumeration locals;
    private String localName;
    private int localPort = -1;
    private String method;
    private String pathInfo;
    private String pathTranslated;
    private String protocol;
    private String queryString;
    private String remoteAddr;
    private String remoteHost;
    private int remotePort = -1;
    private String remoteUser;
    private String requestURI;
    private StringBuffer requestURL;
    private String schema;
    private String serverName;
    private int serverPort = -1;
    private String servletPath;
    private HttpSession session;
    private Principal principal;
    private Enumeration<String> requestHeaderNames;
    private Map<String, Enumeration<String>> headersMap = new ConcurrentHashMap<String, Enumeration<String>>();
    private String requestedSessionId;

    public HttpServletRequestSnapshot(HttpServletRequest request) {
        super(request);
        this.authType = request.getAuthType();
        this.characterEncoding = request.getCharacterEncoding();
        this.contentLength = request.getContentLength();
        this.contentType = request.getContentType();
        this.contextPath = request.getContextPath();
        this.cookies = request.getCookies();
        this.requestHeaderNames = request.getHeaderNames();
        Enumeration<String> tmp = request.getHeaderNames();
        while (tmp.hasMoreElements()) {
            String key = tmp.nextElement();
            this.headersMap.put(key, request.getHeaders(key));
        }
        this.localAddr = request.getLocalAddr();
        this.local = request.getLocale();
        this.localName = request.getLocalName();
        this.localPort = request.getLocalPort();
        this.method = request.getMethod();
        this.pathInfo = request.getPathInfo();
        this.pathTranslated = request.getPathTranslated();
        this.protocol = request.getProtocol();
        this.queryString = request.getQueryString();
        this.remoteAddr = request.getRemoteAddr();
        this.remoteHost = request.getRemoteHost();
        this.remotePort = request.getRemotePort();
        this.remoteUser = request.getRemoteUser();
        this.requestURI = request.getRequestURI();
        this.requestURL = request.getRequestURL();
        this.requestedSessionId = request.getRequestedSessionId();
        this.schema = request.getScheme();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        this.servletPath = request.getServletPath();
        if (request.isRequestedSessionIdValid()) {
            this.session = request.getSession();
        }
        this.principal = request.getUserPrincipal();
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookies;
    }

    @Override
    public String getHeader(String name) {
        if (this.headersMap.get(name) != null && this.headersMap.get(name).hasMoreElements()) {
            return this.headersMap.get(name).nextElement();
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        return this.requestHeaderNames;
    }

    public Enumeration getHeaders(String name) {
        return this.headersMap.get(name);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        return this.pathTranslated;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRemoteUser() {
        return this.remoteUser;
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    @Override
    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getLocalAddr() {
        return this.localAddr;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public Locale getLocale() {
        return this.local;
    }

    public Enumeration getLocales() {
        return this.locals;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getScheme() {
        return this.schema;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }
}

