#!perl
use strict;

BEGIN
{
    require Test::More;
    if (! eval { require DBD::SQLite }) {
        Test::More->import(skipall => 'DBD::SQLite not available');
    } else {
        Test::More->import(tests => 6);
    }
}

package MyDATA;
use strict;
use base qw(Class::DBI);
use Class::DBI::Plugin::Senna
    index_filename => 't/test_index',
    index_column   => 'data'
;
__PACKAGE__->set_db(Main => 'dbi:SQLite:dbname=t/test.db', undef, undef, { AutoCommit => 1});
__PACKAGE__->table('MyDATA');
__PACKAGE__->columns(All => qw(id data));

1;

package main;
use strict;

MyDATA->db_Main->do(qq{
    CREATE TABLE MyDATA (
        id PRIMARY KEY,
        data TEXT
    );
});

my $id = 'a';
while (<DATA>) {
    chomp;
    MyDATA->create({ id => $id++, data => $_ });
}

my $iter = MyDATA->fulltext_search("ޤä");
isa_ok($iter, 'Class::DBI::Plugin::Senna::Iterator');
is($iter->count, 2);
while (my $e = $iter->next) {
    ok($e);
}

my $obj = MyDATA->retrieve('b');
$obj->data("Ťθˤ桢ᤢޤ֤ҤޤҤʤˡȤऴȤʤݤˤϤ̤ƻ᤭ޤդꤱꡣ");
$obj->update;

my($rs) = MyDATA->fulltext_search("ƻ᤭ޤդꤱ");
is($rs && $rs->id, 'b');

if ($rs) {
    $rs->delete;
    ($rs) = MyDATA->fulltext_search("ƻ᤭ޤդꤱ");
    ok(!$rs);
} else {
    ok(0);
}

END {
    eval {MyDATA->senna_index->remove};
    eval {unlink("t/test.db")};
}
__DATA__
ˤξ̵ζꡣհмβ֤οɬ򤢤魯ͤפ餺ͣդ̴ΤȤԤˤϤۤӤ̡ФοФƱ
ʤ礦ˡβϡʤ⤦ˡ¤μˡʤ夤ˡϽʤݰϽˤĤ˽鷺ڤߤ򤭤ݸʹŷΤ餺̱ͫܤߤʤΤ˴ӤƤޤä
椬Ǥ⡢ʿʿ硢ŷĤƣͧʤߤȤˡ¤θơʤ褷ˡʿƣʤΤ֤ˡޤʤ˴ӤƤޤä
ǶǤϡϻƻʿīȤͤͭͤʹȡդˤǤʤۤɤ
ĤϴŷĤޤιĻҡʼ븶ʤϤ˿Ʋζλ¹ˤ뻾ʤ̤Τߤޤˤλ¹ǤꡢʤīäˤǤ롣οƲλҡ벦ʤߤˤ̵̵̤Ǥλҹ˾ʤˤΤȤʿäƾˤʤޤ²ϤʤƿͿäϢʤäλҤüܾ˾ʤ褷˹ʤˤˤ̾᤿ˤޤǤϻδ֤ϡμΤǤä˾¤ʤä
